#==============================================================================
# ** Classes.Table_Object                                                    By: Selwyn
#------------------------------------------------------------------------------
# Three Dimensional Array for any Object.
#   
#   - resizing any dimension will destroy the data.
#   - negative values for x, y, z can be used.
#       e.g. table[-1, -1, -1] will return the last object of the table
#
#==============================================================================

MACL::Loaded << 'Classes.Table_Object'

class Table_Object
  #--------------------------------------------------------------------------
  # * Public Instance Variables
  #--------------------------------------------------------------------------
  attr_reader   :xsize
  attr_reader   :ysize
  attr_reader   :zsize
  #--------------------------------------------------------------------------
  # * Name      : Object Initialization
  #   Info      : Creates a new Object Table Object
  #   Author    : Selwyn
  #   Call Info : Two-Three Arguments
  #               Two - Integer xsize, ysize - dimensions
  #               Three - Integer xsize, ysize, zsize - dimensions
  #--------------------------------------------------------------------------
  # EDIT King __King__
  #def initialize(xsize, ysize, zsize = 0)
  def initialize(xsize, ysize, zsize = 1)
    @xsize = xsize
    @ysize = ysize
    @zsize = zsize
    @data = []
    @indexes = []
    make_array
  end
  #--------------------------------------------------------------------------
  # * Name      : Element Reference
  #   Info      : Gets an Element returns Element At ID or X,Y,Z
  #   Author    : Selwyn
  #   Call Info : One-Two-Three Arguments
  #               One - Integer id - id of the element to get
  #               Two - Integer x,y - X and Y.
  #               Three - Integer x,y,z - X, Y and Z. 
  #--------------------------------------------------------------------------
  def [](*args)
    case args.size
    when 1
      return @data[args[0]]
    when 2, 3
      return @data[id(*args)]
    end
  end
  #--------------------------------------------------------------------------
  # * Name      : Element Assignment
  #   Info      : Assigns an Object to Element
  #   Author    : Selwyn
  #   Call Info : Two-Three-Four Arguments
  #               Two Integer id - id of the Element to set 
  #                   Object obj - object assigned to id
  #               Three Integer x,y - X and Y.
  #                     Object obj - object assigned to id.
  #               Four Integer x,y,z - X, Y and Z.
  #                     Object obj - object assigned to id.
  #--------------------------------------------------------------------------
  def []=(*args)
    case args.size
    when 2
      @data[args[0]] = args[1]
    when 3
      @data[id(args[0], args[1])] = args[2]
    when 4
      @data[id(args[0], args[1], args[2])] = args[3]
    end
  end
  #--------------------------------------------------------------------------
  # * Name      : Set X Size
  #   Info      : Sets Width of the Table
  #   Author    : Selwyn
  #   Call Info : One Argument Integer xsize - new size
  #--------------------------------------------------------------------------
  def xsize=(xsize)
    @xsize = xsize
    make_array
  end
  #--------------------------------------------------------------------------
  # * Name      : Set Y Size
  #   Info      : Sets Height of the Table
  #   Author    : Selwyn
  #   Call Info : One Argument Integer ysize - new size
  #--------------------------------------------------------------------------
  def ysize=(ysize)
    @ysize = ysize
    make_array
  end
  #--------------------------------------------------------------------------
  # * Name      : Set Z Size
  #   Info      : Sets Depth of the Table
  #   Author    : Selwyn
  #   Call Info : One Argument Integer zsize - new size
  #--------------------------------------------------------------------------
  def zsize=(zsize)
    @zsize = zsize
    make_array
  end
  #--------------------------------------------------------------------------
  # * Name      : Set Size
  #   Info      : Sets Dimensions of the Table
  #   Author    : Selwyn
  #   Call Info : Two or Three - Integer xsize, ysize, zsize - Dimensions
  #--------------------------------------------------------------------------
  def resize(xsize, ysize, zsize = 0)
    @xsize = xsize
    @ysize = ysize
    @zsize = zsize
    make_array
  end
  #--------------------------------------------------------------------------
  # * Name      : Make Array
  #   Info      : Creates Data Array
  #   Author    : Selwyn
  #   Call Info : No Arguments
  #--------------------------------------------------------------------------
  def make_array
    max = @xsize * @ysize * (@zsize + 1)
    @data = nil
    @data = Array.new(max)
    @indexes = []
    if @zsize > 0
      for i in 0...max
        xy = i % (@xsize * @ysize)
        x = xy % @xsize
        y = xy / @xsize
        z = (i - xy) / (@xsize * @ysize)
        @indexes << [x, y, z]
      end
    else
      for i in 0...max
        @indexes << [i % @xsize, i / @xsize]
      end
    end
  end
  #--------------------------------------------------------------------------
  # * Name      : ID
  #   Info      : Returns id of element
  #   Author    : Selwyn
  #   Call Info : Two or Three Arguments Integer X and Y and Z
  #--------------------------------------------------------------------------
  def id(x, y, z = 0)
    x %= @xsize; y %= @ysize; z %= @zsize
    return (x + y * @xsize) + (@xsize * @ysize * z)
  end
  #--------------------------------------------------------------------------
  # * Name      : Coord
  #   Info      : Gets Coordinates - Array [x, y(, z)]
  #   Author    : Selwyn
  #   Call Info : One Integer ID, Id to get coordinates from
  #--------------------------------------------------------------------------
  def coord(id)
    #xy = id % (@xsize * @ysize)
    #x = xy % @xsize
    #y = xy / @xsize
    #z = (id - xy) / (@xsize * @ysize)
    return @indexes[id]
  end
  #--------------------------------------------------------------------------
  # * Name      : Clear
  #   Info      : Clears the Table
  #   Author    : Selwyn
  #   Call Info : No Arguments
  #--------------------------------------------------------------------------
  def clear
    @data.clear
  end
  #--------------------------------------------------------------------------
  # * Name      : Size
  #   Info      : Returns the Table size
  #   Author    : Selwyn
  #   Call Info : No Arguments
  #--------------------------------------------------------------------------
  def size
    @data.size
  end
  #--------------------------------------------------------------------------
  # * Name      : ID Index
  #   Info      : Returns the ID position of the object in the Table
  #   Author    : Selwyn
  #   Call Info : Object object
  #--------------------------------------------------------------------------
  def id_index(object)
    return @data.index(object)
  end
  #--------------------------------------------------------------------------
  # * Name      : Coord Index
  #   Info      : Returns the Coordinates of the object in the Table
  #   Author    : Selwyn
  #   Call Info : Object object
  #--------------------------------------------------------------------------
  def coord_index(object)
    return coord(@data.index(object))
  end
end